#ifndef _SMARTAUDIO16_H_
#define _SMARTAUDIO16_H_
//
//  SmartAudio16_iOS.h
//
//  Created by Kiyoto Ohtani on 12/01/12.
//
//  Last modify 12/09/27.
//
//  Copyright (c) 2012 puresound. All rights reserved.
//
#include <stdbool.h>
#include <android_native_app_glue.h>

#define SInt8       int8_t
#define SInt16      int16_t
#define SInt32      int32_t
#define UInt8       uint8_t
#define UInt16      uint16_t
#define UInt32      uint32_t

struct CktlAudioVolume {

	UInt8	mTrackVolume[16];

};
typedef struct CktlAudioVolume CktlAudioVolume;

//function======================================================================

//spkgファイル、ヒープサイズを指定して初期化
SInt32 cktlInit(
					ANativeActivity *activity,
					UInt32 heapSize,
					SInt8 player,
					const char* filePath,
					bool debugFlag);

//引数シーケンスと、それにシーケンスで使用するバンクを一括ロード
SInt32 cktlLoadGroup(UInt8 groupNo);

//最上層にあるレイヤーを解放
SInt32 cktlFreeTopLayer();

//積まれているレイヤー数取得
SInt32 cktlGetLayerLevel();

//任意レイヤー番号に紐つけられているグループ番号取得
SInt32 cktlGetGroupNumber(UInt16 playerNo);

//シーケンス番号を指定して、ワンショット再生(途中停止不可)
SInt32 cktlStartUnstoppableSequence(UInt16 labelNo);

//シーケンス番号と音量/パンを指定して、ワンショット再生(途中停止不可)
SInt32 cktlStartUnstoppableSequenceWithParameter(UInt16 labelNo, SInt8 volume, SInt8 pan);

enum {
	cktlPlayerType_BGM			= 0,
	cktlPlayerType_AmbienceA,
	cktlPlayerType_AmbienceB,
};

//シーケンス番号と用途を指定して、ループ再生(途中停止可能)
SInt32 cktlStartStoppableSequence(UInt16 labelNo, UInt8 use);

//シーケンス番号と用途と音量/パンを指定して、ループ再生(途中停止可能)
SInt32 cktlStartStoppableSequenceWithParameter(UInt16 labelNo, UInt8 use, SInt8 volume, SInt8 pan);

//シーケンス番号と音量/パンを指定してシーケンスに準じた再生(途中停止・変更可能)、プレイヤー番号返す
SInt32 cktlStartSequence(UInt16 labelNo, SInt8 volume, SInt8 pan);	//<-new


//用途とフェードアウト時間(msec)を指定して、停止
SInt32 cktlStopStoppableSequence(UInt8 use, UInt16 fadeOutTime);
//プレイヤー番号とフェードアウト時間(msec)を指定して、停止
SInt32 cktlStopSequence(UInt8 playerNo, UInt16 fadeOutMsec);	//<-new

enum {
	cktlPlayerState_Stop		= 0,
	cktlPlayerState_Play,
	cktlPlayerState_Pause,
	cktlPlayerState_FadeOut
};
//用途を指定しての一時停止、もしくは再開
SInt32 cktlPauseStoppableSequence(UInt8 use, UInt8 state);
//演奏中なら一時停止、一時停止中なら演奏再開する
SInt32 cktlPauseSequence(UInt8 playerNo);	//<-new

//ループ再生しているシーケンスのテンポ変更 パーセンテージで指定
SInt32 cktlChangeTempoWithPlayerType(UInt8 use, UInt16 percent);
SInt32 cktlChangeTempo(UInt8 playerNo, UInt16 percent);	//<-new

//ループ再生しているシーケンスの音量変更
SInt32 cktlChangeVolumeWithPlayerType(UInt8 use, SInt8 volume);
SInt32 cktlChangeVolume(UInt8 playerNo, SInt8 volume);	//<-new

//ループ再生しているシーケンスのパン変更
SInt32 cktlChangePanWithPlayerType(UInt8 use, SInt8 pan);
SInt32 cktlChangePan(UInt8 playerNo, SInt8 pan);	//<-new

//ループ再生しているシーケンスのトランスポーズ -24〜24(半音)
SInt32 cktlTransposeKeyWithPlayerType(UInt8 use, SInt8 transpose);
SInt32 cktlTransposeKey(UInt8 playerNo, SInt8 transpose);	//<-new


enum {
	cktlPlayerParameterType_SequenceNo	= 1,
	cktlPlayerParameterType_Status,
	cktlPlayerParameterType_Transpose,
	cktlPlayerParameterType_Tempo
};

//ループ再生しているシーケンスの各パラメータを取得
SInt16 cktlGetStoppableSequenceInfo(UInt8 use, UInt8 parameterType);

//プレイヤーの任意パラメータを取得
SInt16 cktlGetPlayerInfo(UInt8 playerNo, UInt8 parameterType);	//<-new

//各定義情報の個数を取得
enum {
    cktlDataType_Audio      = 1,
    cktlDataType_Bank,
    cktlDataType_CallLabel,
    cktlDataType_Sequence,
    cktlDataType_Group
};

SInt16 cktlGetDataCount(UInt8 dataType);

SInt16 cktlGetCallLabelCount(UInt8 groupNo);

SInt32 cktlGetGroupDataSize(UInt8 groupNo);

//使用しているメモリサイズを取得
//0x01 = スタティック領域(テーブル、変数等)、0x02 = ヒープ領域(定義情報、実データ)
enum {
    cktlMemoryType_Static    = 1 << 0,
    cktlMemoryType_Heap      = 1 << 1
};

SInt32 cktlGetMemorySize(UInt8 type);

//16個のオーディオトラックそれぞれのボリュームを取得
void cktlGetAudioTrackVolume(CktlAudioVolume *audioVolumeStruct);


//コールラベル情報用定数
enum {
	cktlLabelInfoType_GroupNo	= 1,		//所属グループ番号
	cktlLabelInfoType_ReferenceCount,		//参照カウント(0以上であればサウンドヒープ内に存在している)
	cktlLabelInfoType_BankNo,				//使用バンク番号
	cktlLabelInfoType_MasterVolume,			//マスターボリューム
	cktlLabelInfoType_SequencePriority		//シーケンスプライオリティ
};

SInt16 cktlGetLabelInfo(UInt16 labelNo, UInt8 labelInfoType);

char *cktlGetLabelName(UInt16 labelNo);
char *cktlGetGroupName(UInt16 groupNo);

//全シーケンスを停止する
void cktlStopAllSequence();


//システム(コールバック)を一時停止
SInt32 cktlSuspendSystem();

//システム(コールバック)を再開
SInt32 cktlResumeSystem();


//インスタンスを解放する
void cktlDealloc();


//エラーコード一覧(32bit値)
enum
{
	cktlError_NoError                    = 0,	//エラーなし
	cktlError_MemoryAllocFailed             ,	//malloc失敗
	cktlError_PlayerNoIsOutOfRange          ,	//プレイヤー番号範囲外
	cktlError_SeqNoIsOutOfRange             ,	//シーケンス番号範囲外
	cktlError_AudioNoIsOutOfRange           ,	//オーディオ番号範囲外
	cktlError_WrongSeqData                  ,	//シーケンスデータのエンドコード不足
	cktlError_ArchiveFileDoesNotExist       ,	//指定名のアーカイブが存在しない
	cktlError_ArchiveFileDoesNotOpen        ,	//アーカイブオープン用インスタンス作成失敗
	cktlError_TemporaryFileCreationFailure  ,	//一時ファイル作成失敗
	cktlError_SeqDataDoseNotExistOnMemory   ,	//シーケンスデータがメモリ上に無い
	cktlError_AudioDataDoseNotExistOnMemory ,	//オーディオデータがメモリ上に無い
	cktlError_BankNoNotExist                ,	//バンク番号に該当のオーディオが存在しない
	cktlError_NotRelatedWithThePlayer       ,	//プレイヤーとシーケンスが紐ついていない
	cktlError_DataDuringUse                 ,	//プレイヤー使用中データを消そうとした
	cktlError_FileSizeError                 ,	//アーカイブファイルサイズエラー
	cktlError_SarcIdentifierError           ,	//アーカイブ'sarc'識別子不在
	cktlError_BankIdentifierError           ,	//アーカイブ'bank'識別子不在
	cktlError_WarcIdentifierError           ,	//アーカイブ'warc'識別子不在
	cktlError_InfoChankIdentifierError      ,	//アーカイブ'info'識別子不在
	cktlError_DataChankIdentifierError      ,	//アーカイブ'data'識別子不在
	cktlError_OverTheHeapSize				,	//ヒープサイズ超過
	cktlError_OverTheLayerLevel				,	//レイヤー規定値(255)超過
	cktlError_SystemIsUninitialized         ,	//システム未初期化
	cktlError_InitializationError				//システム初期化失敗
};

//==============================================================================

#endif //_SMARTAUDIO16_H_
